# SoloStaff Emailer

> **Release v1.0.0**
> Please report issues at the [GitHub repository](https://github.com/StephenBogner/solostaff-emailer-application/issues).

Email management application for solo staff and small nonprofit organizations.

## Overview

SoloStaff Emailer is a desktop application that helps nonprofits manage email subscribers, create campaigns, and track engagement. Built with Python and PySide6 (Qt), it runs locally on Windows, macOS, and Linux.

### Key Features

- **Subscriber Management** - Import, organize, and maintain contact lists
- **Campaign Editor** - Create email campaigns with templates
- **Segmentation** - Group subscribers for targeted messaging
- **SendGrid Integration** - Professional email delivery with analytics
- **Scheduling** - Schedule campaigns for future delivery
- **Analytics Dashboard** - Track opens, clicks, and engagement
- **GDPR Compliance** - Consent tracking and data privacy

## Screenshots

### Subscriber Management
![Subscribers List](docs/screenshots/01_Subscribers_List.png)

### Campaign Management
![Campaigns List](docs/screenshots/02_Campaigns_List.png)

### Campaign Editor
![Campaign Editor](docs/screenshots/07_Campaign_Editor.png)

### Segments
![Segments List](docs/screenshots/03_Segments_List.png)

### Analytics Dashboard
![Analytics Dashboard](docs/screenshots/04_Analytics_Dashboard.png)

### Settings
![Settings](docs/screenshots/05_Settings.png)

### Template Preview
![Template Preview](docs/screenshots/11_Template_Preview.png)

### Dark Mode
![Dark Mode](docs/screenshots/15_Dark_Mode.png)

<details>
<summary>More screenshots</summary>

| Screenshot | Description |
|------------|-------------|
| ![Add Subscriber](docs/screenshots/06_Add_Subscriber.png) | Add Subscriber dialog |
| ![Campaign Editor Edit](docs/screenshots/08_Campaign_Editor_Edit.png) | Editing an existing campaign |
| ![CSV Export](docs/screenshots/09_CSV_Export.png) | CSV Export dialog |
| ![Manage Tags](docs/screenshots/10_Manage_Tags.png) | Tag management |
| ![Help](docs/screenshots/12_Help_User_Guide.png) | Built-in User Guide |
| ![What's New](docs/screenshots/13_Whats_New.png) | What's New dialog |
| ![Bulk Tag](docs/screenshots/14_Bulk_Tag.png) | Bulk tag operations |
| ![About](docs/screenshots/16_About.png) | About dialog |

</details>

## Quick Start for Testers

### Prerequisites

- Python 3.11 or higher
- Git

### Installation

```bash
# 1. Clone the repository
git clone https://github.com/StephenBogner/solostaff-emailer-application.git
cd solostaff-emailer-application

# 2. Create virtual environment
python -m venv .venv

# 3. Activate virtual environment
# Linux/macOS:
source .venv/bin/activate
# Windows PowerShell:
.venv\Scripts\Activate.ps1
# Windows CMD:
.venv\Scripts\activate.bat

# 4. Install dependencies
pip install -e ".[dev]"

# 5. Run the application
python -m emailer_app
```

### Verify Installation

```bash
# Check Python version (should be 3.11+)
python --version

# Run tests to verify everything works
pytest -q

# Expected output: ~1865 passed, ~84 failed, ~56 skipped
```

## Running the Application

```bash
# Standard launch
python -m emailer_app

# With debug logging
LOG_LEVEL=DEBUG python -m emailer_app

# Or use the installed console script
emailer-app
```

On first launch, the **Getting Started Wizard** will guide you through:

1. Database location setup
2. Email provider configuration (SendGrid or SMTP)
3. Sender information
4. Optional subscriber import

## Project Structure

```text
solostaff-emailer-application/
├── src/emailer_app/          # Main application code
│   ├── ui/                   # PySide6 GUI components
│   ├── models/               # SQLAlchemy ORM models
│   ├── repositories/         # Data access layer
│   ├── services/             # Business logic
│   └── analytics/            # Metrics and reporting
├── tests/                    # Pytest test suite
├── docs/                     # Documentation
│   ├── setup/                # Installation guides
│   ├── user-guide/           # End-user documentation
│   └── testing/              # Testing documentation
└── specs/tasks/              # Task specifications
```

## Development

### Running Tests

```bash
# Run all tests
pytest

# Run with coverage
pytest --cov=src/emailer_app

# Run specific test category
pytest tests/ui/           # UI tests
pytest tests/services/     # Service tests
pytest tests/integration/  # Integration tests

# Run tests matching a pattern
pytest -k "subscriber"
```

### Code Quality

```bash
# Format code
black src/ tests/

# Check formatting without changes
black --check src/ tests/

# Type checking
mypy src/

# Lint code
flake8 src/ tests/
```

### Test Categories

Tests are organized by component:

| Directory | Description |
|-----------|-------------|
| `tests/models/` | ORM model tests |
| `tests/repositories/` | Data access tests |
| `tests/services/` | Business logic tests |
| `tests/ui/` | GUI component tests |
| `tests/integration/` | End-to-end workflow tests |
| `tests/analytics/` | Metrics and reporting tests |
| `tests/security/` | Security audit tests |

## Documentation

| Document | Description |
|----------|-------------|
| [Developer Testing Guide](docs/testing/developer-testing-guide.md) | **Testers start here** - Complete testing walkthrough |
| [Environment Setup](docs/setup/environment-setup.md) | Development environment setup |
| [Quick Start Guide](docs/user-guide/quick-start.md) | End-user quick start |
| [Getting Started](docs/user-guide/getting-started.md) | First-time setup wizard guide |
| [Feature Guides](docs/user-guide/features/) | Detailed feature documentation |
| [Documentation Index](docs/README.md) | Full documentation index |

## Configuration

### Environment Variables

Copy `.env.example` to `.env` and configure:

```bash
cp .env.example .env
```

Key settings:

| Variable | Description | Default |
|----------|-------------|---------|
| `LOG_LEVEL` | Logging level (DEBUG, INFO, WARNING, ERROR) | INFO |
| `DATABASE_PATH` | Custom database location | ~/.solostaff-emailer/data/ |

### SendGrid Setup

1. Create account at [SendGrid](https://sendgrid.com)
2. Generate API key with "Mail Send" permission
3. Configure in application Settings or Getting Started Wizard

## Troubleshooting

### Application Won't Start

```bash
# Verify Python version
python --version  # Should be 3.11+

# Verify PySide6 installation
python -c "import PySide6; print(PySide6.__version__)"

# Check for missing dependencies
pip install -e ".[dev]"
```

### Linux: PySide6 Display Issues

```bash
# Install required system libraries
sudo apt install libgl1-mesa-glx libegl1 libxkbcommon0 libdbus-1-3

# For Wayland issues
export QT_QPA_PLATFORM=xcb
python -m emailer_app
```

### Tests Failing

```bash
# Update dependencies
pip install -e ".[dev]" --upgrade

# Run with verbose output
pytest -v --tb=long
```

### Credential Storage Status

On the Settings screen, you'll see one of three storage statuses:

| Status | Color | Meaning |
|--------|-------|---------|
| Secure storage active | Green | Using OS keyring (Windows Credential Manager, macOS Keychain, Linux Secret Service) |
| File storage active | Blue | Using file-based storage with restricted permissions |
| Using temporary storage | Orange | Memory only - credentials lost when app closes |

**If you see "Using temporary storage":** The required packages may not be installed:

```bash
# Install keyring packages
pip install keyring keyrings.alt

# Restart the application
python -m emailer_app
```

After restart, Settings should show "File storage active" (blue) or "Secure storage active" (green), and your credentials will persist between sessions without requiring a password prompt.

### Database Issues

```bash
# Reset database (WARNING: deletes all data)
rm -rf ~/.solostaff-emailer/data/
python -m emailer_app  # Creates fresh database
```

## License

Copyright 2025 Stephen Bogner, P.Eng. All Rights Reserved.

See [LICENSE.md](LICENSE.md) for full license terms.

## Author

**Stephen Bogner, P.Eng.**

Professional Engineer specializing in software architecture and AI-driven development workflows.
